# LSattr_html_select_object

Ce type est utilisé pour la gestion des attributs dont les valeurs sont des références à d'autres
[LSobjects](../../../index.md#configuration-lsobject). Chaque référence à un objet correspond à une
valeur prise par l'attribut. Les valeurs clés référant à un
[LSobject](../../../index.md#configuration-lsobject) sont soit la valeur d'un de leurs attributs,
soit leur *DN*.

```
'html_options' => array (
   selectable_object => array (
     array (
       'object_type' => '[Type d'LSobject selectionnable]',
       'display_name_format' => '[LSformat du nom d'affichage des LSobjects]',
       'value_attribute' => '[Nom de l'attribut clé des LSobjects]',
       'filter' => '[Filtre de recherche]',
       'onlyAccessible' => '[Booléen]'
     ),
     [...]
   ),
   'ordered' => [Booléen],
   'sort' => [Booléen],
   'sortDirection' => '[ASC|DESC]'
),
...
```

- `selectable_object`

  Tableau dont chaque valeur correspond à un tableau associatif spécifiant un type
  d'[LSobject](../../../index.md#configuration-lsobject) sélectionnable. Pour chaque type d'objet
  sélectionnable, les paramètres suivants doivent être renseignés :

  - `object_type`

    Nom du type d'[LSobject](../../../index.md#configuration-lsobject) en référence
    *(Paramètre obligatoire)*.

  - `display_name_format`

    [LSformat](../../../global/LSformat.md#format-parametrable) du nom d'affichage des objets lors
    de leur sélection *(Paramètre facultatif)*.

  - `value_attribute`

    Nom de l'attribut des [LSobjects](../../../index.md#configuration-lsobject) en référence servant
    de valeur clé et permettant de les identifier *(Paramètre obligatoire, exemples : `dn` ou `uid`)*.

  - `filter`

    Filtre de recherche qui sera ajouter au filtre par défaut lors  de la sélection des objets
    *(Paramètre facultatif)*.

  - `onlyAccessible`

    Booléen définissant si seul les LSobjets auxquels l'utilisateur connecté à accès doivent être
    considérés comme sélectionnables *(Paramètre facultatif, par défaut: `False`)*.

- `ordered`

  Booléen définissant si la liste des objets choisis doit être ordonnable ou non *(Paramètre
  facultatif, par défaut: `False`)*. Cela aura pour effet d'activer une fonctionnalité dynamique de
  l'interface permettant de remonter ou descendre dans la liste les objets choisis.

  !!! note

      Cette fonctionnalité désactive automatiquement le trie des objets à l'affichage.

- `sort`

  Booléen définissant si la liste des objets choisis doit être triée ou non *(Paramètre facultatif,
  par défaut: `True`)*. Le trie est effectué sur les libellés des objets choisis.

- `sortDirection`

  Mot clé déterminant le sens du trie des objets choisis.

  Valeurs possibles : `ASC` ou `DESC` (`ASC` par défaut).
