# Récupération de mot de passe

Cette section décrit la manière de configurer la récupération de mot de passe par les utilisateurs.
Le mécanisme de récupération de mot de passe fonctionne en deux parties :

- Dans un premier lieu, l'utilisateur ayant perdu son mot de passe accède à l'interface de
  récupération à partir de la page de connexion. L'interface lui demande de saisir son identifiant
  et éventuellement de sélectionner le serveur LDAP concerné. Une fois ces informations saisies, une
  recherche de l'utilisateur est effectuée dans l'annuaire et si celui-ci est trouvé, la valeur de
  l'attribut `recoveryHashAttr` de l'objet est alors redéfinie avec une valeur aléatoire.

  Un mail est ensuite envoyé à l'utilisateur en utilisant la première valeur de l'attribut
  `mailAttr` comme adresse. Ce mail est formé à partir des paramètres du tableau associatif
  `recoveryHashMail`.
  Celui-ci doit contenir le sujet du mail dans `subject` et le corps du message dans `msg`. Ces deux
  informations sont des [formats paramètrables](../LSformat.md#format-parametrable) composés avec,
  comme valeur clé, l'URL de retour à laquelle l'utilisateur devra se rendre pour accèder à la
  seconde étape de la récupération de son mot de passe.

- L'utilisateur doit donc se rendre sur l'interface par l'intermédiaire de l'URL qui lui aura été
  fournie dans le mail de l'étape précédente. Cette URL contient la valeur de l'attribut
  `recoveryHashAttr` précédement définie. A partir de cette information, une recherche est effectuée
  dans l'annuaire pour retrouver l'utilisateur correspondant.

  Si l'utilisateur est retrouvé, un nouveau mot de passe lui est généré en utilisant les paramètres
  de configuration éventuellement définis dans la configuration HTML de l'attribut "mot de passe".
  Pour avoir plus d'information sur ces paramètres, consulter la documentation du type d'attribut
  HTML
  [*LSattr_html_password*](../../LSobject/LSattribute/LSattr_html/LSattr_html_password.md#lsattr_html_password).
  L'attribut `recoveryHashAttr` est quant à lui supprimé.

  Ensuite, un mail est composé à partir des paramètres du tableau associatif `newPasswordMail` et
  est envoyé à l'utilisateur. Ce tableau doit contenir le sujet du mail dans `subject` et le corps
  du message dans `msg`. Ces deux informations sont des
  [formats paramètrables](../LSformat.md#format-parametrable) composés avec, comme valeur clé, le
  nouveau mot de passe de l'utilisateur.

```
'recoverPassword' => array(
  'mailAttr' => '[attribut mail]',
  'recoveryHashAttr' => '[attribut hash]',
  'recoveryEmailSender' => '[adresse mail utilisée par LdapSaisie pour l'envoi des mails]',
  'recoveryHashMail' => array(  // 1er mail : avec l'URL pour l'accès à la 2nde partie
    'subject' => '[sujet du mail]',
    'msg' => "[message contenant le mot clé %{url}]"
  ),
  'newPasswordMail' => array(  // 2nd mail : avec le mot de passe
    'subject' => '[sujet du mail]',
    'msg' => "[message contenant le mot clé %{mdp}]"
  )
),
...
```
