<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/


/**
 * Element select d'un formulaire pour LdapSaisie
 *
 * Cette classe définis les éléments select des formulaires.
 * Elle étant la classe basic LSformElement.
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 */

class LSformElement_select extends LSformElement {

  var $template = 'LSformElement_select.tpl';
  var $fieldTemplate = 'LSformElement_text_field.tpl';

  var $fetchVariables = array(
    'additionalCssClass' => array("LSformElement_select"),
  );

 /**
  * Return display data of this element
  *
  * This method return display data of this element
  *
  * @return array
  */
  public function getDisplay(){
    $return = $this -> getLabelInfos();
    $params = array();
    if (!$this -> isFreeze()) {
      LStemplate :: addHelpInfo(
        'LSformElement_select',
        array(
          'clear' => _("Reset selection.")
        )
      );
      LStemplate :: addJSscript('LSformElement_select.js');
    }
    $params['possible_values'] = $this -> params['text_possible_values'];
    $params['allow_custom_values'] = $this -> getParam('html_options.allow_custom_values', false);
    if ($params['allow_custom_values'])
      $params['custom_values'] = array_filter(
        $this -> values,
        function($value) use ($params) {
          return !self :: _isValidValue($value, $params["possible_values"]);
        }
      );
    $params['unrecognized_value_label_format'] = _("%{value} (unrecognized value)");
    $return['html'] = $this -> fetchTemplate(NULL,$params);
    return $return;
  }

 /**
  * Check if a value is valid for the current form element
  *
  * This method check if a value is correct, that mean if it's one
  * of the possible values.
  *
  * @param string $value The value to check
  *
  * @return string or False The value's label or False if this value is incorrect
  */
  public function isValidValue($value) {
    return self :: _isValidValue(
      $value,
      $this -> getParam('text_possible_values'),
      $this -> getParam('html_options.allow_custom_values', false)
    );
  }

 /**
  * Check if a value is valid against specified possible values
  *
  * This method check if a value is correct, that mean if it's one
  * of the possible values.
  *
  * @param string $value The value to check
  * @param array $possible_values The possible values
  * @param boolean $allow_custom_values Allow custom values (optional, default: false)
  *
  * @return string|false The value's label or False if this value is incorrect
  */
  public static function _isValidValue($value, $possible_values, $allow_custom_values=false) {
    if (!is_array($possible_values)) {
      return False;
    }

    $ret = False;
    if (is_array($possible_values)) {
      foreach($possible_values as $key => $name) {
        if (is_array($name)) {
          if (!is_array($name['possible_values'])) continue;
          foreach($name['possible_values'] as $k => $v) {
            if ($k==$value) {
              $ret=$v;
              break;
            }
          }
          if ($ret) break;
        }
        elseif ($key==$value) {
          $ret=$name;
          break;
        }
        if ($ret) break;
      }
    }
    if ($ret === false && $allow_custom_values && is_string($value))
      return $value;
    return $ret;
  }

  /**
   * CLI autocompleter for form element attribute values
   *
   * @param array &$opts                      Array of avalaible autocomplete options
   * @param string $comp_word                 The (unquoted) command word to autocomplete
   * @param string $attr_value                The current attribute value in command word to
   *                                          autocomplete (optional, default: empty string)
   * @param string $multiple_value_delimiter  The multiple value delimiter
   *                                          (optional, default: "|")
   * @param string $quote_char                The quote character detected
   *                                          (optional, default: empty string)
   *
   * @return void
   */
  public function autocomplete_attr_values(&$opts, $comp_word, $attr_value="", $multiple_value_delimiter="|", $quote_char='') {
    // Split attribute values and retrieved splited value in $attr_values and $last_attr_value
    if (!$this -> split_autocomplete_attr_values($attr_value, $multiple_value_delimiter, $attr_values, $last_attr_value))
      return;

    foreach ($this -> params['text_possible_values'] as $value => $label) {
      if (is_array($label)) {
        foreach ($label['possible_values'] as $v => $l) {
          $this -> add_autocomplete_attr_value_opts($opts, $attr_values, $v, $multiple_value_delimiter, $quote_char);
        }
      }
      else {
        $this -> add_autocomplete_attr_value_opts($opts, $attr_values, $value, $multiple_value_delimiter, $quote_char);
      }
    }
  }


  /**
   * Retrieve value as return in API response
   *
   * @param boolean $details If true, returned values will contain details if this field type
   *                             support it (optional, default: false)
   *
   * @return mixed API value(s) or null/empty array if no value
   */
  public function getApiValue($details=false) {
    $values = array();
    foreach(ensureIsArray($this -> values) as $value) {
      $label = $this -> _isValidValue(
        $value,
        $this -> params['text_possible_values'],
        $this -> getParam('html_options.allow_custom_values', false)
      );
      if ($label === false) continue;
      if ($details)
        $values[] = array(
          'label' => $label,
          'value' => $value,
        );
      else
        $values[] = $value;
    }
    if ($this -> isMultiple()) {
      return ensureIsArray($values);
    }
    if (!$values)
      return null;
    return $values[0];
  }

}

/**
 * LSformElement_select_checkIsValidValue template function
 *
 * This function permit to check during template processing
 * if a value is valid. This function get as parameters
 * (in $params) :
 * - $value : the value to check
 * - $possible_values : the possible values of the element
 * As return, this function assign two template variables :
 * - LSformElement_select_isValidValue :
 *     Boolean defining if the value is valid
 * - LSformElement_select_isValidValue_label :
 *     The value's label
 *
 * @param array $params The template function parameters
 * @param Smarty $template Smarty object
 *
 * @return void
 **/
function LSformElement_select_checkIsValidValue($params, $template) {
  $ret = LSformElement_select :: _isValidValue(
    $params['value'],
    $params['possible_values'],
    LSconfig :: get('allow_custom_values', false, "bool", $params)
  );

  $template -> assign('LSformElement_select_isValidValue',$ret !== false);
  $template -> assign('LSformElement_select_isValidValue_label',$ret === false ? "" : $ret);
}
LStemplate :: registerFunction('LSformElement_select_checkIsValidValue','LSformElement_select_checkIsValidValue');

# vim: tabstop=2 shiftwidth=2 softtabstop=2 expandtab
