# LSattr_html_password

Ce type est utilisé pour la gestion des attributs dont la valeur est un mot de passe.

```
'html_options' => array(
  'isLoginPassword' => [booleen],
  'generationTool' => [booleen],
  'autoGenerate' => [booleen],
  'length' => [nombre de caractères],
  'chars' => array ( // Caractères que peut contenir le mot de passe
    array( // Liste caractère avec un nombre mininum d'apparition supérieur à 1
      'nb' => [nb caractères],
      'chars' => '[liste de caractères possibles]'
    ),
    '[autre liste de caractères possibles]', // Liste caractère avec un nombre
                                             // d'apparitions égal à 1
    ...
  ),
  'use_pwgen' => [booléen], // Utiliser pwgen pour la génération du mot de passe
  'pwgen_path' => "/path/to/pwgen",
  'pwgen_opts' => "[options à passer à pwgen]",
  'verify' => [booléen],  // Activation de l'outil de vérification du mot de passe
  'viewHash' => [booléen],  // Activation de l'outil de visualisation du mot de passe haché
  'confirmChange' => [booléen],  // Activation de la confirmation en cas de changement du mot de passe
  'confirmChangeQuestion' => "[LSformat]",  // LSformat de la question de confirmation du changement du mot de passe
  'mail' => array( // Configuration de l'envoi du mot de passe par mail
    'subject' => "[LSformat du sujet du mail]",
    'msg' => "[LSformat du message du mail]",
    'mail_attr' => 'mail', // Attribut mail de l'objet
    'get_mail_attr_function' => '[function]', // Fonction retournant l'attribut mail de l'objet
    'send' => 1,  // Activation par défaut de l'envoi du mot de passe
    'ask' => 1,   // Laisser le choix à l'utilisateur
    'canEdit' => 1,   // Activation de l'édition du LSformat du message par l'utilisateur
    'checkDomain' => false, // Désactivation de la vérification du domaine de l'adresse email
    'domain' => '[nom de domaine]', // Nom de domaine obligatoire lors de la validation de l'adresse email
  )
),
...
```

- `isLoginPassword`

  Booléen définissant si le mot de passe est celui utilisé par l'utilisateur pour se logguer à
  l'annuaire LDAP. Si c'est le cas, pour vérifier si le mot de passe correspond avec un autre, une
  tentative de connexion de l'utilisateur à l'annuaire sera faite. (Par défaut : `False`)

- `generationTool`

  Booléen définissant si l'outil de génération de mot de passe est activé.

- `autoGenerate`

  Active la génération automatique du mot de passe lorsque l'attribut n'a encore aucune valeur de
  définie. Il faut également que l'outil de génération soit activé (`generationTool`).

- `length`

  Nombre de caractères que devront contenir les mots de passe générés.

- `chars`

  Tableau contenant une liste de listes de caractères possibles pour composer le mot de passe. Dans
  chacune de ces listes, au moins un caractère sera utilisé dans le nouveau mot de passe. Il est
  possible de définir un nombre supérieur de caractères d'une liste devant apparaître dans les mots
  de passe générés en spécifiant un tableau associatif dont la clé *nb* associra le nombre entier de
  caractères et la clé *chars* la liste de caractères. Une liste de caractères est un chaîne.

- `use_pwgen`

  Booléen définissant si la commande `pwgen` doit être utilisé pour générer le mot de passe.

- `pwgen_path`

  Chemin d'accès au binaire `pwgen`. (Par défaut : `pwgen`).

- `pwgen_opts`

  Options à passer à la commande `pwgen`.

- `verify`

  Booléen définissant si l'outil de vérification du mot de passe est activé. Si celui-ci est activé,
  l'utilisateur pourra entrer un mot de passe dans le champ et cliquer sur un bouton qui lancera une
  procédure de vérification du mot de passe via un test de connexion à l'annuaire.

- `viewHash`

  Booléen définissant si l'utilisateur aura accès à la fonctionnalité de visualisation du mot de
  passe haché.

- `confirmInput`

  Booléen définissant si un second champ mot de passe sera affiché dans le formulaire pour que
  l'utilisateur confirme la saisie du nouveau mot de passe.

- `confirmInputError`

  [LSformat](../../../global/LSformat.md#format-parametrable) du message d'erreur affiché à
  l'utilisateur si le mot de passe saisie dans le champs de confirmation ne correspond pas au
  nouveau mot de passe. *Paramètre facultatif.*

- `confirmChange`

  Booléen définissant si l'utilisateur devra confirmer le changement de ce mot de passe. Lorsque
  cette fonctionnalité est activée, l'utilisateur verra apparaître une popup de confirmation à la
  validation du formulaire s'il a saisi un nouveau mot de passe.

- `confirmChangeQuestion`

  [LSformat](../../../global/LSformat.md#format-parametrable) de la question posée à l'utilisateur
  en cas de changement du mot de passe et si la fonctionnalité est activée. Il sera composé à l'aide
  du *label* de l'attribut. *Paramètre facultatif.*

- `clearView`

  Booléen définissant si l'utilisateur pourra voir le mot de passe en clair par défaut (y comris en
  mode visualisation uniquement).

- `clearEdit`

  Booléen définissant si l'utilisateur éditera le mot de passe au travers un champs HTML de type
  *text* et donc lisible ou au travers un champs HTML de type *password*.

- `mail`

  Paramètres de configuration de l'envoi par mail du mot de passe à l'utilisateur. Lorsque cet outil
  est activé, lors de la modification/création du mot de passe, l'utilisateur pourra recevoir un
  mail lui spécifiant son nouveau mot de passe.

  - `send`

    Booléen définissant si l'envoi du mot de passe est activé par défaut.

  - `ask`

    Booléen définissant si on laisse le choix à l'utilisateur d'activer ou non l'envoi du mot de
    passe par mail.

  - `canEdit`

    Booléen définissant si on laisse la possibilité à l'utilisateur d'éditer le
    [LSformat](../../../global/LSformat.md#format-parametrable) du message et du sujet.

  - `subject`

    [LSformat](../../../global/LSformat.md#format-parametrable) du sujet du mail. Ce format sera
    composé avec la valeur du nouveau mot de passe de l'utilisateur.

  - `msg`

    [LSformat](../../../global/LSformat.md#format-parametrable) du message du mail. Ce format sera
    composé avec les informations de l'object LDAP, y compris le mot clé *%{password}* correspondant
    à la valeur du nouveau mot de passe de l'utilisateur.

  - `mail_attr`

    Le nom de l'attribut listant les mails possibles de l'utilisateur. Par défaut, la première
    valeur de l'attribut sera utilisée comme adresse mail destinatrice. Cet attribut peut également
    être un tableau de plusieurs noms d'attributs. Dans ce cas, la première valeur correcte sera
    retenue. Si `canEdit` est activé, l'utilisateur pourra choisir l'adresse mail destinatrice parmi
    la liste des valeurs de l'attribut.

  - `get_mail_attr_function`

    Nom de la fonction (ou `callable` au sens PHP) qui sera utilisé pour récupérer le nom de
    l'attribut listant les mails possibles de l'utilisateur. Cette fonction prendra en paramètre,
    l'objet `LSformElement` courant et devra retourner une valeur équivalente au paramètre de
    configuration `mail_attr`. Si ce paramètre est défini, il prévalera toujours sur le paramètre
    `mail_attr`.

  - `bcc`

    Mettre en *BCC* un mail systématiquement (ou plusieurs en les séparant par des virgules).

  - `headers`

    Un tableau de type clé/valeur ou la clé est le nom d'un header à ajouter au mail et la valeur
    est la valeur de l'header en question.

  - `checkDomain`

    Booléen définissant si le domaine de l'adresse mail doit être validée. *Paramètre facultatif,
    par défaut: `True`

  - `domain`

    Nom de domaine obligatoire lors de la validation de l'adresse mail. Ce paramètre peut être une
    simple chaine correspondant au domaine ou un tableau listant plusieurs domaines valides.
    *Paramètre facultatif, par défaut tous les domaines sont acceptés.*
