var LSrelation = new Class({
    initialize: function(){
      this.labels = varLSdefault.LSjsConfig['LSrelation_labels'];
      if (!$type(this.labels)) {
        this.labels = {
          delete_all:              'Delete all',
          delete_confirm_title:    'Warning',
          delete_confirm_validate: 'Delete'
        };
      }

      this.edit = 0;
      this.deleteBtn = [];
      this.deleteBtnId = 0;
      this.refreshRelation=0;
      this._confirmDelete=1;
      $$('a.LSrelation_modify').each(function(el) {
        this.edit=1;
        el.addEvent('click',this.onLSrelationModifyBtnClick.bindWithEvent(this,el));
        // Clone modify button to create the all related objects button
        var btn = el.getParent().clone();
        var a = btn.getElement("a");
        a.href = "#";
        a.removeClass("LSrelation_modify");
        a.getElement("img").src = "image/delete";
        a.getElement("span").innerHTML = this.labels.delete_all;
        btn.injectAfter(el.getParent());
        btn.addEvent('click',this.onLSrelationDeleteAllBtnClick.bindWithEvent(this, a));
      }, this);
      if (this.edit) {
        this.initializeBtn();
      }
    },

    initializeBtn: function() {
      $$('img.LSrelation-btn').each(function(el) {
        el.destroy();
      }, this);
      this.deleteBtnId = 0;
      $$('a.LSrelation_editable').each(function(a) {
        this.deleteBtn[this.deleteBtnId] = new Element('img');
        this.deleteBtn[this.deleteBtnId].src = varLSdefault.imagePath('delete');
        this.deleteBtn[this.deleteBtnId].setStyle('cursor','pointer');
        this.deleteBtn[this.deleteBtnId].addClass('LSrelation-btn');
        this.deleteBtn[this.deleteBtnId].addEvent(
          'click',
          this.onDeleteBtnClick.bind(this,this.deleteBtn[this.deleteBtnId])
        );
        this.deleteBtn[this.deleteBtnId].injectAfter(a);
        a.getParent().id=this.deleteBtnId;
        this.deleteBtnId++;
      }, this);
    },

    onDeleteBtnClick: function(img) {
      var ul = img.getParent('ul');
      var a = img.getPrevious('a');
      var getRelationId = /LSrelation_ul_([0-9]*)/
      var relation_id = getRelationId.exec(ul.id)[1];
      if (this._confirmDelete) {
        this.confirmBox = new LSconfirmBox({
          text:           getFData(
            varLSdefault.LSjsConfig['LSrelations'][relation_id]['deleteOneConfirmText'],
            a.innerHTML
          ),
          title:          this.labels.delete_confirm_title,
          validate_label: this.labels.delete_confirm_validate,
          startElement:   img,
          onConfirm:      this.deleteFromImg.bind(
            this, {img: img, a: a, relation_id: relation_id}
          ),
        });
      }
      else {
        this.deleteFromImg.bind(
          this, {img: img, a: a, relation_id: relation_id}
        );
      }
    },

    deleteFromImg: function(data) {
      data.img.destroy();
      new Request({
        url: 'ajax/class/LSrelation/deleteByDn',
        data: {
          id:      data.relation_id,
          dn:      this.a2dn(data.a),
          imgload: varLSdefault.loadingImgDisplay(data.a, 'inside'),
        },
        onSuccess: this.deleteFromImgComplete.bind(this)
      }).send();
    },

    deleteFromImgComplete: function(responseText, responseXML) {
      var data = JSON.decode(responseText);
      if ( varLSdefault.checkAjaxReturn(data) && data['success']) {
        try  {
          var ul=$('LSrelation_ul_'+data.id);
          var li = $('LSrelation_'+data.id+'_'+data.dn).getParent();
          li.destroy();
          if (!$type(ul.getFirst())) {
            var getId = /LSrelation_ul_([0-9]*)/
            var id = getId.exec(ul.id)[1];

            var newli = new Element('li');
            newli.addClass('LSrelation');
            newli.set('html',varLSdefault.LSjsConfig['LSrelations'][id]['emptyText']);
            newli.injectInside(ul);
          }
        }
        catch(e) {
          LSdebug('Error while deleting the li of DN : '+data.dn);
        }
      }
    },

    onLSrelationModifyBtnClick: function(event,a) {
      new Event(event).stop();
      var relation_id = a.getProperty('data-relation-id');
      this.refreshRelation = relation_id;
      new Request({
        url: 'ajax/class/LSrelation/initSelection',
        data: {
          id:      relation_id,
          href:    a.href,
          imgload: varLSdefault.loadingImgDisplay('LSrelation_title_'+relation_id,'inside'),
        },
        onSuccess: this.onLSrelationModifyBtnClickComplete.bind(this),
      }).send();
    },

    onLSrelationModifyBtnClickComplete: function(responseText, responseXML) {
      var data = JSON.decode(responseText);
      if ( varLSdefault.checkAjaxReturn(data) && data['success'] ) {
        varLSsmoothbox.asNew();
        varLSsmoothbox.addEvent('valid', this.onLSsmoothboxValid.bind(this));
        varLSsmoothbox.openURL(
          data.href,
          {
            startElement: $$('a.LSrelation_modify[data-relation-id='+data.id+']').getFirst(),
            width: 635
          }
        );
      }
    },

    onLSrelationDeleteAllBtnClick: function(event, a) {
      new Event(event).stop();
      var relation_id = a.getProperty('data-relation-id');
      this.confirmBox = new LSconfirmBox({
        text:           varLSdefault.LSjsConfig['LSrelations'][relation_id]['deleteAllConfirmText'],
        title:          this.labels.delete_confirm_title,
        validate_label: this.labels.delete_confirm_validate,
        startElement:   a,
        onConfirm:      this.deleteAllBtnFromBtn.bind(this, {a: a, relation_id: relation_id}),
      });
    },

    deleteAllBtnFromBtn: function(data) {
      new Request({
        url: 'ajax/class/LSrelation/deleteAll',
        data: {
          id:      data.relation_id,
          imgload: varLSdefault.loadingImgDisplay(data.a, 'inside'),
        },
        onSuccess: this.deleteAllBtnFromBtnComplete.bind(this),
      }).send();
    },

    deleteAllBtnFromBtnComplete: function(responseText, responseXML) {
      var data = JSON.decode(responseText);
      if ( varLSdefault.checkAjaxReturn(data) && data['success']) {
        if (data.deleted) {
          try  {
            var ul = $('LSrelation_ul_'+data.id);
            for (const dn of Object.keys(data.deleted)) {
              var li = $('LSrelation_'+data.id+'_'+dn).getParent();
              li.destroy();
            }

            if (!$type(ul.getFirst())) {
              var getId = /LSrelation_ul_([0-9]*)/
              var id = getId.exec(ul.id)[1];

              var newli = new Element('li');
              newli.addClass('LSrelation');
              newli.set('html',varLSdefault.LSjsConfig['LSrelations'][id]['emptyText']);
              newli.injectInside(ul);
            }
          }
          catch(e) {
            LSdebug('Error while deleting related objects lis of relation '+data.id);
          }
        }
      }
    },

    onLSsmoothboxValid: function() {
      new Request({
        url: 'ajax/class/LSrelation/updateFromSelection',
        data: {
          id:      this.refreshRelation,
          imgload: varLSdefault.loadingImgDisplay('LSrelation_title_'+this.refreshRelation,'inside'),
        },
        onSuccess: this.onLSsmoothboxValidComplete.bind(this)
      }).send();
    },

    onLSsmoothboxValidComplete: function(responseText, responseXML) {
      var data = JSON.decode(responseText);
      if ( varLSdefault.checkAjaxReturn(data) && data['success'] ) {
        $('LSrelation_ul_'+this.refreshRelation).set('html',data.html);
        this.initializeBtn();
      }
    },

    a2dn: function(a) {
      var getId = /LSrelation_[0-9]*_(.*)$/
      return getId.exec(a.id)[1];
    }

});

window.addEvent(window.ie ? 'load' : 'domready', function() {
  varLSrelation = new LSrelation();
});

// vim: tabstop=2 shiftwidth=2 softtabstop=2 expandtab
