# Profils d'utilisateurs (LSprofile)

Cette section décrit la manière dont sont définis les profils d'utilisateurs se connectant à
l'interface appelés *LSprofile*. Il est possible d'attribuer un profil à l'utilisateur connecté sur
tout ou partie de l'annuaire LDAP.

## Profils d'utilisateurs par défaut

Il existe des profils d'utilisateurs par défaut, non liée à la configuration de l'application:

- `user`

  Tous les utilisateurs connectés à l'utilisateur. Ce *LSprofile* est valide sur l'ensemble de
  l'annuaire.

- `self`

  L'utilisateur connecté sur son objet correspondant dans l'annuaire. Ce *LSprofile* est utile pour
  donner des droits à l'utilisateur sur lui-même.

- `nom du type de l'objet connecté`

  Un *LSprofile* du nom du type d'objet utilisateur connecté est automatiquement ajouté à
  l'utilisateur. Ainsi, si l'utilisateur connecté est un
  [LSobject](../../LSobject/index.md#configuration-lsobject) `LSpeople` par exemple, il aura le
  *LSprofile* `LSpeople` sur tous l'annuaire. Ce *LSprofile* est utile pour donner des droits à tous
  un type d'objets pouvant se connecter à l'application (par exemple, tous les utilisateurs
  applicatifs).

## Profils d'utilisateurs personalisés

Il est possible de définir autant de profils d'utilisateurs que l'on souhaite. Pour chaque profil
d'utilisateur personnalisé, il faudra définir dans quelles parties de l'annuaire ce profil existe
(Exemple : les admistrateurs de groupes existent uniquement dans la branche de l'annuaire stockant
les groupes). Enfin pour chaque partie de l'annuaire, il faudra définir la manière d'identifier si
l'utilisateur qui se connecte appartient à ce profil.

```
'LSprofile' => array (
  [nom d'un LSprofile] => array (
    [label] => [label du LSprofile],
    [basedn] => [dn utilisateur],
    [autre basedn] => array (
      [dn d'un utilisateur] => NULL,
      [autre dn] => array ( // via un listage de l'attribut d'un objet
        'attr' => [nom de l'attribut clé de l'objet],
        'attr_value' => [format de la valeur de l'attribut clé],
        'LSobject' => [nom du type LSobject de l'objet]
      )
    ),
    'LSobjects' => array ( // via une liste d'objet sur lequel l'utilisateur a des pouvoirs
      [nom du LSobject] => array (
        'attr' => [nom de l'attribut clé],
        'attr_value' => [format de la valeur de l'attribut clé],
        // ou
        'filter' => [format du filtre de recherche],

        'basedn' => [basedn de recherche],
        'params' => [configuration de la recherche]
      ),
      [nom quelconque] => array (
        'filters' => array(
          array(
            'LSobject' => [nom du LSobject],
            'attr' => [nom de l'attribut clé],
            'attr_value' => [format de la valeur de l'attribut clé],
            // ou
            'filter' => [format du filtre de recherche],

            'basedn' => [basedn de recherche],
            'params' => [configuration de la recherche]
          ),
        ),
      ),
      ...
    )
  ),
  ...
),
...
```

Le paramètre `LSprofiles` est un tableau associatif contenant, en valeur clé, le nom d'un
*LSprofile* et en valeur associée, la configuration nécessaire pour déterminer si l'utilisateur
connecté appartient à ce LSprofile pour tout ou partie de l'annuaire.

Dans chaque configuration de *LSprofile*, il est possible d'identifier l'appartenance ou non de
l'utilisateur connecté de deux manières :

- Pour une branche de l'annuaire donnée (*basedn*) : en listant les utilisateurs appartenant à ce
  *LSprofile* pour tous les objets de la branche. Il sera possible de lister les utilisateurs dont
  on connait le *DN* ou de lister les utilisateurs appartenant à une liste stockée dans l'annuaire
  (par exemple la liste des membres d'un groupe).

  - Liste des DNs d'utilisateurs :

    ```
    'LSprofile' => array (
      [nom du LSprofile] => array (
        [basedn] => [dn utilisateur],
        // ou si plusieurs DNs
        [autre basedn] => array (
          [dn d'un utilisateur] => NULL,
          [dn d'un utilisateur 2] => NULL
        ),
        ...
      ),
      ...
    ),
    ...
    ```

    Explication : Pour un *LSprofile* et un *basedn* donnés, on définit l'utilisateur appartenant au
    *LSprofile* en donnant son *DN*. Si on souhaite lister plusieurs utilisateurs, on utilise un
    tableau associatif dans lequel les clés sont les *DNs* des utilisateurs et les valeurs associées
    sont toutes *NULL*.

  - Liste d'utilisateurs stockée dans l'annuaire :

    ```
    'LSprofile' => array (
      [nom du LSprofile] => array (
        [basedn] => array (
          [DN d'un object] => array (
            'attr' => [nom de l'attribut clé de l'objet],
            'attr_value' => [format de la valeur de l'attribut clé],
            'LSobject' => [nom du type LSobject de l'objet]
          )
        ),
      ...
    ),
    ...
    ```

    Explication : Pour un *LSprofile* et un *basedn* donnés, on liste les utilisateurs du
    *LSprofile* référencés dans l'attribut `attr` de l'object de type `LSobject` et selon le format
    de valeur décrit dans `attr_value`.

- Pour un type de *LSobject* donné : en listant les objets pour lesquels l'utilisateur aura les
  droits du LSprofile. Il sera possible, à travers une recherche paramétrable dans l'annuaire, de
  lister les objets pour lesquels l'utilisateur appartiendra au *LSprofile*.

  ```
  'LSprofile' => array (
    [nom d'un LSprofile] => array (
      'LSobjects' => array ( // via un liste d'objet pour lequel l'utilisateur
                             // appartient au LSprofile
        [nom du LSobject] => array (
          'attr' => [nom de l'attribut clé],
          'attr_value' => [format de la valeur de l'attribut clé],
          // or
          'filter' => [format du filtre de recherche],

          'basedn' => [format du basedn de recherche],
          'params' => [configuration de la recherche]
        ),
        array (
          'filters' => array(
            array(
              'LSobject' => [nom du LSobject],
              'attr' => [nom de l'attribut clé],
              'attr_value' => [format de la valeur de l'attribut clé],
              // ou
              'filter' => [format du filtre de recherche],

              'basedn' => [format du basedn de recherche],
              'params' => [configuration de la recherche]
            ),
          ),
        ),
        ...
      )
    ),
    ...
  ),
  ...
  ```

  Explications : Dans la configuration d'un *LSprofile*, la valeur clé *LSobjects* signifie qu'on
  est dans un cas de la délégation de droits sur des types d'LSobject. Dans ce tableau associatif,
  il est possible de définir un ou plusieurs types de LSobject pour lesquels on délègue des droits
  via des recherches simples ou enchaînées. Le fonctionnement simple consiste à partir de l'objet de
  l'utilisateur et à générer un filtre et une base de recherche sur un type de LSobject. Le
  fonctionnement enchainée consiste à faire un première recherche à partir de l'objet de
  l'utilisateur puis à recommencer à partir des objets trouvés en construisant une liste de filtres
  de recherche pour chaque objet qui seront combinés via l'opérateur booléen *ou*. Dans le cadre
  d'un fonctionnement enchainée, la base de recherche est toujours générer à partir de l'objet de
  l'utilisateur connecté.

  Pour configurer une délégation de type simple on mettra le nom du LSobject dans la clé du tableau
  et dans la valeur un tableau définissant la recherche. Il est possible de ne pas utiliser la clé
  du tableau comme nom du LSobject grâce à la clé de configuration *LSobject*.

  Pour configurer une délégation de type enchaîné on pourra utiliser n'importe quelle valeur unique
  pour la clé du tableau et pour la valeur un tableau contenant une unique clé *filters*. La valeur
  associée à cette clé est celle d'une délégation de type simple où la clé *LSobject* est devenue
  obligatoire.

  Cette configuration contient les paramètres d'une ou plusieurs recherches dans l'annuaire en
  considérant que l'utilisateur connecté aura les droits du LSprofile sur les objets retournés. Les
  paramètres de la recherche sont :

  - `LSobject`

    C'est le nom du LSobject recherché. *(Paramètre facultatif pour
    une délégation de type simple)*

  - `attr`

    Nom de l'attribut des LSobjets contenant une valeur clé qui
    permettra d'identifier l'utilisateur comme ayant droit.

  - `attr_value`

    Le format de la valeur clé prise par l'attribut `attr`. Ce format est composé à partir des
    données de l'objet de l'utilisateur connecté. Voir le paragraphe
    [Format paramètrable](../LSformat.md#format-parametrable) pour plus d'informations sur
    l'écriture du format.

  - `filter`

    Ce paramètre remplace les paramètres `attr` et `attr_value`. Il est possible ici d'écrire
    directement le format paramètrable du filtre recherche dans l'annuaire. Ce filtre sera
    automatiquement agrémenté des conditions sur l'attribut *objectclass*. Voir le paragraphe
    [Format paramètrable](../LSformat.md#format-parametrable) pour plus d'informations sur
    l'écriture du format.

  - `basedn`

    C'est le format paramétrable du *basedn* de la recherche généré à partir de l'utilisateur
    connecté. Il est possible ainsi de la limiter sur les LSojects d'une branche précise de
    l'annuaire. Voir le paragraphe [Format paramètrable](../LSformat.md#format-parametrable) pour
    plus d'informations sur l'écriture du format. *(Paramètre facultatif)*

  - `params`

    C'est un tableau associatif contenant les paramètres étendus de la recherche. Voir le paragraphe
    [Paramètres étendus des recherches dans l'annuaire](../LDAP_search_params.md#parametres-etendus-des-recherches-dans-lannuaire)
    pour plus de détails. *(Paramètre facultatif)*

Par ailleurs, il est possible d'attribuer un label plus explicite à chaque *LSprofile* à l'aide de
la clé `label`. Ce label sera utilisé pour faire référence au *LSprofile* lorsque nécéssaire.
*(Paramètre facultatif)*
