<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

/**
 * LDAP attribute type date
 *
 */
class LSattr_ldap_date extends LSattr_ldap {

  /**
   * Return the display value of the attribute after handling it acording to its LDAP type
   *
   * @param mixed $data The attribute value
   *
   * @return array The display value of the attribute
   */
  public function getDisplayValue($data) {
    $data = ensureIsArray($data);
    if ($this -> getConfig('ldap_options.timestamp', false, 'bool')) {
      return $data;
    }
    $retval=array();
    foreach($data as $val) {
      foreach($this -> getFormats() as $format) {
        $datetime = date_create_from_format($format, $val);
        if ($datetime instanceof DateTime) {
          $retval[] = $datetime -> format('U');
          break;
        }
      }
    }
    return $retval;
  }

  /**
   * Return the update value of the attribute after handling it acording to its LDAP type
   *
   * @param mixed $data The attribute value
   *
   * @return array The processed attribute value
   */
  public function getUpdateData($data) {
    $data = ensureIsArray($data);
    if ($this -> getConfig('ldap_options.timestamp', false, 'bool')) {
      return $data;
    }
    $timezone = timezone_open($this -> getConfig('ldap_options.timezone', 'UTC', 'string'));
    $retval = array();
    foreach($data as $val) {
      $datetime = date_create("@$val");
      $datetime -> setTimezone($timezone);
      $datetime_string = $datetime -> format($this -> getFormats(true));

      // Replace +0000 or -0000 end by Z
      $datetime_string = preg_replace('/[\+\-]0000$/', 'Z', $datetime_string);

      $retval[] = $datetime_string;
    }
    return $retval;
  }

 /**
  * Return the storage date formats
  * Note: The first one will be used to store the value
  *
  * @return array<string> The storage date formats
  **/
  public function getFormats($first=false) {
    $formats = $this -> getConfig('ldap_options.formats', [], 'array');
    if (!$formats) {
      $format = $this -> getConfig('ldap_options.format');
      $formats = $format ? [$format] : ['YmdHisO', 'YmdHis.vO', 'YmdHis.uO'];
    }
    if ($first)
      return $formats?$formats[0]:null;
    return $formats;
  }

}

# vim: tabstop=2 shiftwidth=2 softtabstop=2 expandtab
