#!/bin/bash

cd $( dirname $0 )

# Need to use Dockerfile+ (https://github.com/edrevo/dockerfile-plus)
export DOCKER_BUILDKIT=1
export COMPOSE_DOCKER_CLI_BUILD=1
DISTS=(bookworm bullseye buster)
LATEST_DIST=${DISTS[0]}

for dist in ${DISTS[@]}
do
	docker build -t brenard/ldapsaisie:$dist -f Dockerfile.$dist .
	[ $? -eq 0 ] && docker push brenard/ldapsaisie:$dist
done

docker build -t brenard/ldapsaisie:latest -f Dockerfile.$LATEST_DIST .
[ $? -eq 0 ] && docker push brenard/ldapsaisie:latest
