# Introduction

LdapSaisie est une application web d'administration d'annuaire LDAP développée en PHP/Javascript.
Cette application a pour but d'abstraire la complexité d'un annuaire par l'intermédiraire d'une
interface d'administration simple et intuitive. L'application a été concue avec pour objectif
premier une modularité maximum, ce qui permet l'extention ou l'adaptation facile de l'application
par l'intermédiaire de modules, d'extentions et de greffons. Cette application peut être utilisée
pour administrer le système d'information basé sur l'annuaire LDAP et également en paralèlle pour
permettre aux utilisateurs d'avoir accès aux données les concernants et éventuellement de les
modifier.

## Fonctionnalités

De part sa modularité, LdapSaisie est facilement extensible. Cependant, voici une liste
non-exhaustive de ses fonctionnalités :

- Gestion d'annuaire simple et multi-branches
- Gestion d'un nombre illimité de types d'objets
- Gestion d'un nombre illimité de populations se connectant à l'interface
- Gestion fine des droits des utilisateurs, permettant la maitrise des droits d'accès sur les objets
  de l'annuaire et leurs atributs, tout en permettant la délégation de droits.
- Gestion d'un grand nombre de types d'attributs :

  - Texte (court ou long)
  - Date (format paramétrable)
  - Booléen (valeurs paramétrables)
  - Image/Photo
  - Mot de passe (génération de mot passe avec gestion d'une politique fine)
  - Adresse mail
  - Flux RSS
  - Lien web (URL)
  - Adresse XMPP
  - Maildir
  - Quota de mails
  - Clef publique SSH
  - Liste déroulante à choix simple ou multiple
  - Relation à d'autres objets de l'annuaire/ Exemple : membres d'un groupe, parrain d'un
    utilisateur, ... (valeur clé paramétrable)

    !!! note

        Chaque type d'attribut à des fonctionnalités qui lui sont propres et qui rendent plus facile
        et agréable l'utilisation de l'interface (génération automatique de mot de passe, génération
        des valeurs d'un champ à partir d'autres, ...).

- Gestion d'un grand nombre de règles de vérification des valeurs des attributs :
  - Alpha-numérique
  - Lettres uniquement
  - Longeur maximale/minimale d'une chaine de caractères
  - Valeur différente de zéro
  - Pas de signe de ponctuation
  - Valeur numérique
  - Comparaison de valeur
  - Date
  - Adresse mail
  - Poids d'une image
  - Taille d'une image
  - Type de fichiers images
  - Politique de mot de passe (longueur/caractères autorisés/caractères obligatoires)

- Gestion simplifiée des relations entre les objets de l'annuaire
- Interface facilement personnalisable grâce à l'utilisation d'un système de template.
- Possibilité de postionner des déclencheurs permettant d'exécuter vos propres scripts, fonctions ou
  méthodes au moments précis ou l'utilisateur créé, modifie ou supprime un objet ou un de ses
  attributs. Ces déclencheurs, en fonction de leur positionnement, peuvent influencer le
  comportement de l'application en empêchant par exemple, la validation des données d'un formulaire.
- Gestion fine de l'affichage des attributs en fonction de l'écran (=vue) sur lequel se trouve
  l'utilisateur.
- Gestion des dépendances entre attributs, permettant par exemple de regénérer automatiquement la
  valeur d'un attribut caché lors de la modification d'un autre.
- Possibilité de gérer des attributs entièrement cachés, dont les valeurs seront modifiées lors de
  la modification d'attribut en dépendance.
