# LSattr_html_date

Ce type est utilisé pour la gestion des attributs dont la valeur est une date. L'outil de sélection
de date [MooTools-DatePicker](http://mootools.net/forge/p/mootools_datepicker) est utilisé pour la
sélection graphique de la date et de l'heure.

```
'html_options' => array (
  'format' => '[Format d'affichage de la date]',
  'time' => '[Booleen pour le choix ou non de l heure]',
  'manual' => '[Booleen pour l edition manuelle ou non]',
  'showNowButton' => '[Booleen]',
  'showTodayButton' => '[Booleen]',
  'style' => '[Nom du style utilise]',
  'special_values' => array (
    '[value]' => '[label]',
    [...]
  ),
),
...
```

- `format`

  Format d'affichage de la date dans le champ de saisie. Ce format est composé à partir des motifs
  clés suivants :

  | Mot clé | Valeur de substitution                                                                                                                    | Exemple de valeur                                                      |
  | ------- | ----------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------- |
  | `%a`    | Nom abrégé du jour de la semaine                                                                                                          | De Sun à Sat                                                           |
  | `%A`    | Nom complet du jour de la semaine                                                                                                         | De Sunday à Saturday                                                   |
  | `%b`    | Nom du mois, abrégé, suivant la locale                                                                                                    | De Jan à Dec                                                           |
  | `%B`    | Nom complet du mois, suivant la locale                                                                                                    | De January à December                                                  |
  | `%c`    | Date et heure préférées, basées sur la locale                                                                                             | Exemple : Tue Feb 5 00:45:10 2009 pour le 5 Février 2009 à 12:45:10 AM |
  | `%d`    | Jour du mois en numérique, sur 2 chiffres (avec le zéro initial)                                                                          | De 01 à 31                                                             |
  | `%e`    | Jour du mois, avec un espace précédant le premier chiffre. L'implémentation Windows est différente, voyez après pour plus d'informations. | De 1 à 31                                                              |
  | `%H`    | L'heure, sur 2 chiffres, au format 24 heures                                                                                              | De 00 à 23                                                             |
  | `%I`    | Heure, sur 2 chiffres, au format 12 heures                                                                                                | De 01 à 12                                                             |
  | `%j`    | Jour de l'année, sur 3 chiffres avec un zéro initial                                                                                      | 001 à 366                                                              |
  | `%m`    | Mois, sur 2 chiffres                                                                                                                      | De 01 (pour Janvier) à 12 (pour Décembre)                              |
  | `%M`    | Minute, sur 2 chiffres                                                                                                                    | De 00 à 59                                                             |
  | `%p`    | 'AM' ou 'PM', en majuscule, basé sur l'heure fournie                                                                                      | Exemple : AM pour 00:31, PM pour 22:23                                 |
  | `%s`    | Timestamp de l'époque Unix (identique à la fonction time())                                                                               | Exemple : 305815200 pour le 10 Septembre 1979 08:40:00 AM              |
  | `%S`    | Seconde, sur 2 chiffres                                                                                                                   | De 00 à 59                                                             |
  | `%T`    | Identique à "%H:%M:%S" Exemple : 21:34:17 pour 09:34:17 PM                                                                                |                                                                        |
  | `%U`    | Numéro de la semaine de l'année donnée, en commençant par le premier Lundi comme première semaine                                         | 13 (pour la 13ème semaine pleine de l'année)                           |
  | `%w`    | Représentation numérique du jour de la semaine                                                                                            | De 0 (pour Dimanche) à 6 (pour Samedi)                                 |
  | `%y`    | L'année, sur 2 chiffres                                                                                                                   | Exemple : 09 pour 2009, 79 pour 1979                                   |
  | `%Y`    | L'année, sur 4 chiffres                                                                                                                   | Exemple : 2038                                                         |
  | `%z`    | Soit le décalage horaire depuis UTC, ou son abréviation (suivant le système d'exploitation)                                               | Exemple : -0500 ou EST pour l'heure de l'Est                           |
  | `%Z`    | Le décalage horaire ou son abréviation NON fournie par %z (suivant le système d'exploitation)                                             | Exemple : -0500 ou EST pour l'heure de l'Est                           |
  | `%%`    | Le caractère de pourcentage ("%")                                                                                                         | \---                                                                   |


  !!! note

      La valeur par défaut est *%d/%m/%Y, %T*. Exemple : *23/04/2009, 23:03:04*

- `time`

  Booléen définissant si l'outil de sélection permetra ou non le choix de l'heure en plus de la date

- `manual`

  Booléen autorisant ou non l'édition manuelle du champs. Si ce paramètre vaut `False`, la sélection
  se fera uniquement à l'aide de l'outil graphique

- `showNowButton`

  Booléen définissant si le bouton *Maintenant* est affiché ou non. Par défaut, il est affiché.

- `showTodayButton`

  Booléen définissant si le bouton *Aujourd'hui* est affiché ou non. Par défaut, il est affiché.

- `style`

  Nom du style d'affichage de l'outil de sélection. Les valeurs possibles sont par défaut :

  - `default`
  - `dashboard`
  - `vista`
  - `jqui`

  !!! note

      La création de nouveau thème est possible. Pour plus d'information, consulter
      [l'aide de l'outil de sélection de date](http://mootools.net/forge/p/mootools_datepicker).

- `special_values`

  Tableau listant les valeurs spéciales que peut prendre l'attribut. Dans ce tableau associatif, la
  clé doit correspondre à la valeur de l'attribut (telle que fournie par
  [l'attribut LDAP](../LSattr_ldap/LSattr_ldap_date.md#lsattr_ldap_date)) et la valeur associée au
  label associé.

  Ces valeurs spéciales seront proposées à l'utilisateur sous la forme de cases à cocher dans le
  formulaire. Elles peuvent permettre par exemple de données une signification particulière au zéro
  pour un attribut LDAP stockant un *timestamp*.
