# zxcvbn

Cette règle vérifie la sécurité d'un mot de passe en utilisant la librairie
[ZxcvbnPhp](https://gitlab.easter-eggs.com/ee/zxcvbn-php). Cette librairie s'appuie sur un ensemble
de vérifications permettant de déterminer à quel point le mot de passe choisi est commun, prévisible
et plus globalement, estime en combien de temps il pourra être cassé par une personne malveillante.
Sur la base de l'analyse du mot de passe saisi, des conseils seront donnés à l'utilisateur pour le
guider dans le choix d'un mot de passe sûre.

!!! warning

    La librairie `ZxcvbnPhp` n'est compatible qu'avec PHP 7 et supérieur.

- `minScore`

  Le score minimal pour que le mot de passe soit accepté. Il doit s'agir d'un entier cimpris entre 0
  (le plus faible) et 4 (le plus sécurisé). Paramètre facultatif valant 4 par défaut.

- `userDataAttrs`

  Liste d'attributs de l'objet dont les valeurs seront passées à la librairie `Zxcvbn` qui les
  considérera comme associés à l'utilisateur. Ainsi, par exemple, si l'utilisateur utilise son nom
  de famille ou encore son prénom dans son mot de passe, la librairie pourra lui indiqué que cela ne
  le protège que peut des attaques ciblées. Paramètre facultatif, mais il est fortement conseillé de
  renseigner un maximum d'attributs contenant des informations personnelles relatives à l'utilisteur.

- `showWarning`

  Booléen définissant si les messages d'alertes retournés par la librairie `Zxcvbn` doivent être
  affichés à l'utilisateur. Paramètre facultatif et vrai par défaut.

- `showSuggestions`

  Booléen définissant si les messages de suggestions retournés par la librairie `Zxcvbn` doivent
  être affichés à l'utilisateur. Paramètre facultatif et vrai par défaut.

- `customDictionaries`

  Tableau associatif permettant de configurer des dictionnaires personnalisés : les clés contiennent
  le nom de la collection de dictionnaires et les valeurs associées, le chemin vers un fichier JSON
  contenant la collection de dictionnaires. Ces fichiers doivent contenir un objet racine dont les
   clés sont des chaînes de caractères correspondant au nom des dictionnaires et les valeurs
  associés sont des listes de mots __en minuscule__ triées par ordre décroissant de fréquence
  d'utilisation.

  Exemple:

  ```json
  {
    "dictionnaire1": ["mot1", "mot2"],
    "dictionnaire2": ["mot3", "mot4"]
  }
  ```

- `zxcvbn_autoload_path`

  Le chemin vers le fichier de chargement automatique des classes de la librairie *ZxcvbnPhp*. Ce
  paramètre est facultatif et vaut par défaut `Zxcvbn/autoload.php`, ce qui est adapté si vous
  utiliser le paquet Debian `php-zxcvbn` disponible sur le dépôt Debian du projet LdapSaisie.
