<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

/**
 * LSform check rule from a list of possible values
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 */
class LSformRule_inarray extends LSformRule {

  // CLI parameters autocompleters
  protected static $cli_params_autocompleters = array(
    'possible_values' => null,
    'reverse' => array('LScli', 'autocomplete_bool'),
  );

  /**
   * Check the value in configured list
   *
   * @param string $value The value to check
   * @param array $options Check options:
   *                              - possible_values: the list of valid values (required)
   *                              - reverse: if true, reverse the logic of the check
   *                              (list values are prohibited, optional, default: False)
   * @param LSformElement &$formElement The related LSformElement object
   *
   * @return boolean true if the value is valid, false otherwise
   */
  public static function validate($value, $options, &$formElement) {
    $possible_values = LSconfig :: get('params.possible_values', null, null, $options);
    $reverse = LSconfig :: get('params.reverse', false, 'bool', $options);
    if (!is_array($possible_values)) {
      LSerror :: addErrorCode('LSformRule_inarray_01');
      return false;
    }
    if (!in_array($value, $possible_values))
      return $reverse;
    return !$reverse;
  }

}

/*
 * Error Codes
 */
LSerror :: defineError('LSformRule_inarray_01',
___("LSformRule_inarray : Possible values has not been configured to validate data.")
);

# vim: tabstop=2 shiftwidth=2 softtabstop=2 expandtab
