# Les vues personnalisées

Les [LSaddons](../../conf/index.md#configuration-des-lsaddons) peuvent fournir des vues personnalisées qui
seront accessibles à tout ou parties des utilisateurs de l'application. Ce filtrage d'accès sera
fait en utilisant les [LSprofiles](../../conf/global/ldap/LSprofile.md#profils-dutilisateurs) de
l'utilisateur connecté sur la
[racine courante de l'annuaire LDAP](../../conf/global/ldap/subDn.md#sous-niveaux-de-connexion).

Pour mettre en place une telle vue personnalisée, il est nécessaire de :

- Déclarer cette vue dans la fonction `LSaddon_[addon]_support` de l'addon à l'aide de la méthode
  `LSsession :: registerLSaddonView()` ;

- Déclarer la fonction implémentant cette vue. Cette fonction n'acceptera aucun paramètre et ne
  retournera rien. Elle devra en outre s'occuper de définir son fichier template et charger les
  dépendances de ce dernier (fichiers *CSS & JS*, variables...).

Pour implémenter une telle vue personnalisée, vous pouvez vous inspirer de l'exemple fourni
ci-dessous ou encore des vues fournies par les autres
[LSaddons](../../conf/index.md#configuration-des-lsaddons) (par exemple, l'addon
[exportSearchResultAsCSV](../../conf/LSaddon/LSaddon_exportSearchResultAsCSV.md#lsaddon_exportsearchresultascsv)).

**Structure du fichier includes/addons/LSaddons.[addon name].php :**

```php
<?php
function LSaddon_myaddon_support() {

  $retval=true;

  // Some check

  if ($retval) {
      $retval = LSsession :: registerLSaddonView(
          'myaddon',          // addon name
          'myaddon_view',     // addon view ID
          __('MyAddon view'), // addon view label
          'myaddon_view',     // callable (ex: function name) that implement addon view
          array('user'),      // array listing allowed LSprofiles
          true                // Show/hide this addon view in user menu
      );
  }

  return $retval;
}

[...]

/**
 * My addon view handler function
 *
 * Description of this view
 *
 * @author My Name <my.email@example.com>
 *
 * @return void
 **/
function myaddon_view() {
    // Do some stuff and set some template variables
    $list = array ([...]);
    LStemplate :: assign('list', $list);

    // Load some CSS & JS files need on this view
    LStemplate :: addCssFile('LSaddon_myadon.css');
    LStemplate :: addJSscript('LSaddon_myadon.js');

    // Set template file of the view
    LSsession :: setTemplate('LSaddon_myadon_view.tpl');
}
```
