# LSattr_ldap_pwdHistory

Ce type est utilisé pour la gestion de l'attribut standard *pwdHistory*. Cet attribut, accessible en
lecture uniquement, stocke dans un format prédéfini l'historique des mots de passe d'une utilisateur
avec pour chaque entrée :

- la date et heure de l'ajout du mot de passe dans l'historique
- l'OID de la syntaxe du mot de passe
- la longueur du mot de passe
- le mot de passe (hâché)

Ce type d'attribut LDAP permettra de convertir la valeur en son équivalent `JSON` pour pouvoir être
traité à l'aide du type d'attribut HTML
[LSattr_html_jsonCompositeAttribute](../LSattr_html/LSattr_html_jsonCompositeAttribute.md#lsattr_html_jsoncompositeattribute).

**Exemple de valeur de l'attribut pwdHistory :**

```
20201202144718Z#1.3.6.1.4.1.1466.115.121.1.40#105#{SSHA512}XDSiR6Sh6W7gyVIk6Rr2OUv8rNPr+0rHF99d9lcirE/TnnEdkjkncIi5iPubErL5lpfgh8gXLgSfmqvmFcMqXLToC25xIqyk
```

**Exemple de valeur tranformée :**

```
{"time":1606920438,"syntaxOID":"1.3.6.1.4.1.1466.115.121.1.40","length":105,"hashed_password":"{SSHA512}XDSiR6Sh6W7gyVIk6Rr2OUv8rNPr+0rHF99d9lcirE/TnnEdkjkncIi5iPubErL5lpfgh8gXLgSfmqvmFcMqXLToC25xIqyk"}
```

**Exemple de configuration complète de l'attribut :**

```
'pwdHistory' => array (
    'label' => 'Passwords in history',
    'ldap_type' => 'pwdHistory',
    'html_type' => 'jsonCompositeAttribute',
    'html_options' => array (
      'components' => array (
        'time' => array (
          'label' => 'Date added to history',
          'type' => 'text',
          'required' => true,
          'multiple' => false,
        ),
        'syntaxOID' => array (
          'label' => 'Syntax OID',
          'type' => 'text',
          'required' => true,
          'multiple' => false,
        ),
        'length' => array (
          'label' => 'Length',
          'type' => 'text',
          'required' => true,
          'multiple' => false,
        ),
        'hashed_password' => array (
          'label' => 'Hashed password',
          'type' => 'text',
          'required' => true,
          'multiple' => false,
        ),
      ),
    ),
    'no_value_label' => 'History is empty.',
    'multiple' => 1,
    'rights' => array(
      'admin' => 'r',
    ),
    'view' => 1,
),
```

La date et heure de l'ajout du mot de passe dans l'historique est convertie dans un format lisible.
Par défaut, ce format est `AAAA/MM/JJ HH:MM:SS`, mais il peut aussi est personnalisé via le
paramètre `date_format`. Ce format est composé à partir des motifs clés gérés par la fonction
`date()` de PHP. Pour plus d'information, consulter
[la documentation officielle](http://www.php.net/date).

!!! note

    La valeur par défaut est *YmdHisO*, correspondant à la syntaxe `Generalized Time` telle que
    définie dans la [RFC4517](https://tools.ietf.org/html/rfc4517) et prévu par le
    [Draft-behera-ldap-password-policy](http://tools.ietf.org/id/draft-behera-ldap-password-policy-10.txt)
    spécifiant cet attribut standard.
