# LSattr_html_select_list

Ce type est utilisé pour la gestion des attributs dont les valeurs font partie d'une liste statique
ou dynamique. Il est possible de lister des valeurs statiques et également des références à d'autres
[LSobjects](../../../index.md#configuration-lsobject). La référence à un objet correspond à une
valeur clé, référente à un objet précis, qui peut être soit la valeur d'un de ses attributs, soit
son *DN*.

```
'html_options' => array (
   'possible_values' => array (
     '[LSformat de la valeur clé]' => '[LSformat du nom d'affichage]',
     ...
     'OTHER_OBJECT' => array (
       'object_type' => '[Type d'LSobject]',
       'display_name_format' => '[LSformat du nom d'affichage des LSobjects]',
       'value_attribute' => '[Nom de l'attribut clé]',
       'values_attribute' => '[Nom de l'attribut clé multi-valeur]',
       'filter' => '[Filtre de recherche des LSobject]',
       'scope' => '[Scope de la recherche]',
       'basedn' => '[Basedn de la recherche]',
       'onlyAccessible' => '[Booléen]'
     ),
     'OTHER_ATTRIBUTE' => '[attr]',
     // Or :
     'OTHER_ATTRIBUTE' => array(
       '[attr1]' => '[label1]',
       '[attr2]' => '[label2]',
       [...]
     ),
     // Or :
     'OTHER_ATTRIBUTE' => array(
       'attr' => [attr],
       'json_component_key' => '[Composant JSON clé]',
       'json_component_label' => '[Composant JSON label]',
     ),
     array (
       'label' => '[LSformat du nom du groupe de valeurs]',
       'possible_values' => array (
         '[LSformat de la valeur clé]' => '[LSformat du nom d'affichage]',
         ...
         'OTHER_OBJECT' => array (
           ...
         )
       )
     )
   ),
   'get_possible_values' => [callable],
   'translate_labels' => [booléen],
   'sort' => [Booléen],
   'sortDirection' => '[ASC|DESC]'
),
...
```

- `possible_values`

  Tableau associatif obligatoire contenant en valeur clé le
  [LSformat](../../../global/LSformat.md#format-parametrable) des valeurs clés prisent par
  l'attribut et en valeurs associées, le [LSformat](../../../global/LSformat.md#format-parametrable)
  des noms d'affichage de ces valeurs. Ces [LSformats](../../../global/LSformat.md#format-parametrable)
  sont composés à partir des valeurs de l'objet courant (attributs, dn, ...).

  Si la valeur clé est égale à `OTHER_OBJECT`, une liste
  d'[LSobject](../../../index.md#configuration-lsobject) sera insérée dans la liste des valeurs
  possibles. La valeur associée est alors un tableau associatif dont les valeurs clés sont les noms
  des paramètres de configuration de la recherche de ces
  [LSobjects](../../../index.md#configuration-lsobject) et les valeurs associées, les valeurs des
  paramètres.

  Il est possible de regrouper des valeurs de l'attribut en plaçant leur déclaration dans un
  sous-tableau. Ce sous-tableau devra contenir la clé `label` dont la valeur associé sera le
  [LSformat](../../../global/LSformat.md#format-parametrable) du nom du groupe de valeurs. Ce
  [LSformat](../../../global/LSformat.md#format-parametrable) est composé à partir des valeurs de
  l'objet courant (attributs, dn, ...). Une seconde clé `possible_values` regroupera les valeurs
  possibles du groupe. Comme pour le tableau principal, la clé `OTHER_OBJECT` permet d'imcorporer
  une liste d'[LSobject](../../../index.md#configuration-lsobject).

  - `object_type`

    Nom du type d'[LSobject](../../../index.md#configuration-lsobject) en référence.

  - `display_name_format`

    [LSformat](../../../global/LSformat.md#format-parametrable) du nom d'affichage des objets lors
    de leur sélection.

  - `value_attribute`

    Nom de l'attribut des [LSobjects](../../../index.md#configuration-lsobject) en référence servant
    de valeur clé et permettant de les identifier (Exemple : `dn` ou `uid`).

  - `values_attribute`

    Nom de l'attribut des [LSobjects](../../../index.md#configuration-lsobject) en référence servant
    de catalogue de valeurs. Dans ce mode, la valeur n'a pas de label et est affichée directement
    dans l'interface. Ce paramètre peut-être utilisé en complément ou non du paramètre
    `value_attribute`.

  - `filter`

    Filtre falcultatif de la recherche des LSobjets. Il sera dans tous les cas agrémenté des valeurs
    des *objectclass* du type d'[LSobject](../../../index.md#configuration-lsobject).

  - `scope`

    Scope falcultatif de la recherche des LSobjets.

  - `basedn`

    Basedn falcultatif de la recherche des LSobjets.

  - `onlyAccessible`

    Booléen falcultatif définissant si seul les LSobjets auxquels l'utilisateur connecté à accès
    doivent être considérés comme sélectionnables (Faux par défaut).

  Si la valeur clé est égale à `OTHER_ATTRIBTE`, une liste de valeur possible sera composée à l'aide
  des valeurs d'un (ou plusieurs) autre attribut de l'objet courant. La valeur associée peut être
  alors :

  - soit le nom d'un attribut dont les valeurs seront utilisées comme valeurs possibles (la valeur
    affichée est égale à la valeur stockée).

  - soit un tableau associatif dont les valeurs clés sont les noms des attributs dont les valeurs
    seront utilisés comme valeurs possibles et dont les valeurs associés seront les labels sous
    lesquels ces valeurs seront regroupées (la valeur affichée est égale à la valeur stockée).

  - soit un tableau associatif référençant un attribut sous la clé `attr` dont les valeurs seront
    utilisées comme valeurs possibles. Cet attribut peut-être du type
    [LSattr_html_jsonCompositeAttribute](LSattr_html_jsonCompositeAttribute.md#lsattr_html_jsoncompositeattribute).
    Il sera alors possible d'utiliser les valeurs d'un composant en particulier en le référençant à
    l'aide de la clé `json_component_key`. Il est également possible de référencer un autre
    composant à l'aide de la clé `json_component_label` et dont les valeurs seront utilisées comme
    valeurs affichées lors de la sélection. À défaut, les valeurs affichées seront identiques à
    celles stockées.

- `get_possible_values`

  Paramètre permettant de spécifier un *callable* qui sera utilisé pour lister les valeurs possibles
  de l'attribut. Il recevra en paramètres les informations suivantes:

  - `$options`

    Les options HTML de l'attribut.

  - `$name`

    Le nom de l'attribut.

  - `&$ldapObject`

    Une référence à l'objet `LSldapObject`.

  La valeur de retour attendue est un tableau associatif des valeurs possibles de l'attribut avec la
  valeur que prendra l'attribut en tant que clé et le label correspondant en tant que valeur. Tout
  autre retour sera considéré comme un échec et déclenchera une erreur.

  Il est également possible de regrouper des valeurs possibles de l'attribut: pour cela, le tableau
  retourné devra lui-même contenir un tableau associatif contenant la label traduit du groupe sous
  la clé `label` et les valeurs possibles du groupe sous la clé `possible_values`.

  Les valeurs retournées pourront être combinées avec les autres valeurs possibles configurées de
  l'attribut. La prise en charge du tri des valeurs possibles est assurée par la fonction appelante
  sauf dans le cas des sous-groupes de valeurs possibles. Dans ce cas, la méthode
  `LSattr_html_select_list :: _sort()` pourra être utilisée pour trier les valeurs du sous-groupe :
  cette méthode accepte en paramètre une référence du tableau des valeurs possibles ainsi que les
  options HTML de l'attribut.

  Si la traduction des labels des valeurs possibles de l'attribut est activées (voir ci-dessous),
  celle-ci doit être prise en charge par la fonction configurée.

- `translate_labels`

  Booléen permettant d'activer/désactiver la traduction des labels (Par défaut : `True`).

- `sort`

  Booléen définissant si les valeurs possibles doivent être triées ou non (Vrai par défaut). Le trie
  est effectué sur les libellés des valeurs possibles.

- `sortDirection`

  Mot clé déterminant le sens du trie des valeurs possibles.

  Valeurs possibles : `ASC` ou `DESC` (`ASC` par défaut).
