# Déclencheurs

Cette section décrit la manière de paramétrer des déclencheurs afin que LdapSaisie exécute durant
ses processus, et à des moments bien précis des traitements d'un
[LSattributes](index.md#configuration-des-attributs), des fonctions que vous pourrez développer vous
même. De plus, le résultat de l'exécution de vos fonctions pourra influer sur le déroulement des
processus.

Actuellement, les évènements suivant sont gérés :

| Nom             | Description                                                              | Bloquant |
| --------------- | ------------------------------------------------------------------------ | -------- |
| `before_create` | Avant la création du LSobject, lorsque l'attribut a au moins une valeur. | Oui      |
| `after_create`  | Après la création du LSobject, lorsque l'attribut a au moins une valeur. | Non      |
| `before_modify` | Avant la modification de la valeur de l'attribut.                        | Oui      |
| `after_modify`  | Après la modification de la valeur de l'attribut.                        | Non      |
| `before_delete` | Avant la suppression du LSobject contenant l'attribut.                   | Oui      |
| `after_delete`  | Après la suppression du LSobject contenant l'attribut.                   | Non      |

!!! note

    Si un événement est dit *bloquant*, lors de l'exécution des actions liées, si une des fonctions
    retourne `false`, le processus s'arrêtera.

## Configuration

La configuration des déclencheurs se fait dans la définition des
[LSattributes](index.md#configuration-des-attributs). Par exemple, pour définir les fonctions à
exécuter après la modification de la valeur de l'attribut *mail* du type de
[LSobject](../index.md#configuration-lsobject) *LSpeople*, c'est à dire lors de leur évenement
`after_modify`, il faut définir la variable suivante :

```
$GLOBALS['LSobjects']['LSpeople']['attrs']['mail']['after_modify']
```

Cette variable peut contenir soit une chaine de caractères correspondant au nom de la fonction à
exécuter, soit un tableau de chaînes de caractères correspondant aux noms des fonctions à exécuter.

## Écriture d'une fonction

Une fonction exécuté par un déclencheur d'un LSattribute se déclare de la manière suivante :

```php
/*
 * Ma fonction à exécuter lors de l'évènement [event]
 *
 * Paramètre :
 *     - $object : Le LSobject contenant le LSattribute sur lequel l'évenement
 *                 survient
 *
 * Valeurs retournées :
 *     - True : Tout s'est bien passé
 *     - False : Une erreur est survenue ou la fonction souhaite bloquer le
 *               processus lors d'un évènement bloquant.
 */
function maFonction ($object) {

  // Actions

}

```

Cette fonction doit prendre pour seul paramètre, le LSobject contenant le LSattribute sur lequel
l'évenement survient et doit retourner soit `True` si tout s'est bien passé, soit `False` en cas de
problème. Dans le cas d'un événement bloquant, si la fonction retourne `False`, le processus est
arrêté.
