<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

class LSmail extends LSlog_staticLoggerClass {

 /*
  * Méthode chargeant les dépendances d'affichage
  *
  * @return void
  */
  public static function loadDependenciesDisplay() {
    if (LSsession :: loadLSclass('LSsmoothbox')) {
      LSsmoothbox :: loadDependenciesDisplay();
    }

    LStemplate :: addJSscript('LSmail.js');
    LStemplate :: addCssFile('LSmail.css');
  }

  public static function ajax_display(&$data) {
    $msg = $_REQUEST['msg'];
    $subject = $_REQUEST['subject'];
    if (
      isset($_REQUEST['object']['type'])
      && isset($_REQUEST['object']['dn'])
      && LSsession ::loadLSobject($_REQUEST['object']['type'])
    ) {
      $obj = new $_REQUEST['object']['type']();
      $obj -> loadData($_REQUEST['object']['dn']);
      $msg = $obj -> getFData($msg);
      $subject = $obj -> getFData($subject);
    }

    LStemplate :: assign('LSmail_msg', $msg);
    LStemplate :: assign('LSmail_subject', $subject);
    LStemplate :: assign('LSmail_options', $_REQUEST['options']);

    if (is_array($_REQUEST['mails'])) {
      LStemplate :: assign('LSmail_mails', $_REQUEST['mails']);
    }
    else if(empty($_REQUEST['mails'])) {
      LStemplate :: assign('LSmail_mails', array($_REQUEST['mails']));
    }

    $data = array(
      'html' => LSsession :: fetchTemplate('LSmail.tpl')
    );
  }

  public static function ajax_send(&$data) {
    if (isset($_REQUEST['infos'])) {
      if (LSsession ::loadLSaddon('mail')) {
        if(sendMail($_REQUEST['infos']['mail'],$_REQUEST['infos']['subject'],$_REQUEST['infos']['msg'])) {
          $data = array(
            'msgok' => _("Your message has been sent successfully.")
          );
        }
      }
    }
    else {
      LSerror :: addErrorCode('LSsession_12');
    }
  }

}
