# LSattr_ldap_password

Ce type est utilisé pour la gestion des attributs dont la valeur est un mot de passe.

```
'ldap_options' => array (
  'encode' => '[Type d'encodage du mot de passe]',
  'encode_function' => '[Nom de la fonction d'encodage]',
  'verify_function' => '[Nom de la fonction de vérification]',
  'no_random_crypt_salt' => '[Booléen]', // Désactivation de l'utilisation d'une salt aléatoire
  'wildcardPassword' => '[mot de passe(s) en clair]',
  'encodedWildcardPassword' => '[mot de passe(s) encodé(s)]'
),
...
```

- `encode`

  Nom du type d'encodage du mot de passe utilisé. Les types d'encodages supportés sont les
  suivants :

  - `argon2` (ou `argon2i`, PHP >= 7.2)
  - `argon2id` (PHP >= 7.3)
  - `md5crypt`
  - `crypt`
  - `ext_des`
  - `blowfish`
  - `sha`
  - `sha256`
  - `sha512`
  - `ssha`
  - `ssha256`
  - `ssha512`
  - `smd5`
  - `md5`
  - `clear`


  !!! note

      Valeur par défaut : `md5crypt`

  !!! important

      Si le type d'encodage est inconnu, ou qu'il n'est pas supporté par le serveur web, un message
      d'erreur alertera l'utilisateur et le mot de passe sera stocké en clair.

- `encode_function`

  Nom d'une function qui sera utilisée afin d'encoder le mot de passe. Cette fonction recevra deux
  paramètres : le `LSldapObject` et le mot de passe en clair.

- `verify_function`

  Nom d'une function qui sera utilisée afin de valider un mot de passe soumis par l'utilisateur par
  rapport à celui stocké dans l'annuaire. Cette fonction recevra trois paramètres : le
  `LSldapObject`,le mot de passe en clair et le mot de passe hashé. Si ce paramètre est omis et que
  le paramètre `encode_function` est défini, le mot de passe à tester sera encodé à nouveau à l'aide
  de la fonction `encode_function` et le résultat sera comparé avec le mot de passe stocké dans
  l'annuaire.

- `no_random_crypt_salt`

  Désactivation de l'utilisation d'une salt générée aléatoirement au profit de l'utilisation des
  deux premiers caractères du mot de passe. Ce paramètre impacte uniquement le type de cryptage
  `crypt`.

- `wildcardPassword`

  Mot de passe (ou tableau de mot de passe) qui sera ajouté systématiquement, en plus du mot de
  passe choisi. Il sera encodé de la même manière que pour le mot de passe choisi avant
  enregistrement.

- `encodedWildcardPassword`

  Mot de passe (ou tableau de mot de passe) qui sera ajouté systématiquement, en plus du mot de
  passe choisi. Contrairement à la directive `wildcardPassword`, le mot de passe ne sera pas encodé
  avant enregistrement.

  !!! note

      Cette directive peut cohabiter avec sa cousine `wildcardPassword`. Les mot de passes contenus
      dans les deux directives seront alors ajoutés.
