# Actions personnalisées (customActions)

Cette section décrit la manière de configurer les actions personnalisées exécutables sur les
[LSobjects](index.md#configuration-lsobject) appelées *customActions*.

```
$GLOBALS['LSobjects']['[nom du type d'LSobject]']['customActions'] = array (
  'action1' => array(
    'label' => '[label l'action]',
    'hideLabel' => '[booléen]',
    'helpInfo' => '[label d'aide]',
    'icon' => '[nom de l'icône de l'action]',
    'function' => '[fonction à exécuter]',
    'question_format' => '[LSformat de la question de confirmation]',
    'onSuccessMsgFormat' => '[LSformat du message à afficher en cas de succès de l'action]',
    'disableOnSuccessMsg' => '[booléen]',
    'noConfirmation' => '[booléen]',
    'redirectToObjectList' => '[booléen]',
    'noRedirect' => '[booléen]',
    'rights' => array(
      'LSprofile1',
      'LSprofile2',
      ...
    )
  )
);
```

- `label`

  Le label de l'action.

- `hideLabel`

  Cache le label dans le bouton de l'action.

- `helpInfo`

  Le label du message d'aide qui sera affiché au survole du bouton de l'action.

- `icon`

  Nom de l'îcone à afficher dans le bouton de l'action. Ce nom correspond au nom du fichier de
  l'image (sans l'extention) qui devra se trouver dans le dossier
  `src/images/[nom du theme d'images]/` ou dans le dossier `src/local/images`.

- `function`

  Le nom de la fonction à exécuter qui implémente l'action personnalisée Cette fonction prendra en
  seule paramètre le [LSobject](index.md#configuration-lsobject) sur lequel l'action devra être
  exécutée et retournera `True` en cas de succès ou `False` en cas d'échec d'exécution de la fonction.

- `question_format`

  Le [LSformat](../global/LSformat.md#format-parametrable) de la question de confirmation
  d'exécution de l'action. Ce [LSformat](../global/LSformat.md#format-parametrable) sera composé à
  l'aide du nom de l'objet.

- `onSuccessMsgFormat`

  Le [LSformat](../global/LSformat.md#format-parametrable) du message à afficher en cas de succès
  d'exécution de l'action. Ce [LSformat](../global/LSformat.md#format-parametrable) sera composé à
  l'aide du nom de l'objet.

- `disableOnSuccessMsg`

  Booléen permetant de désactiver le message afficher en cas de succès d'exécution de l'action.

- `noConfirmation`

  Booléen permetant de désactiver la confirmation de l'exécution de l'action.

- `redirectToObjectList`

  Booléen permetant de rediriger l'utilisateur vers la liste des objets plutôt que sur la fiche de
  l'objet après l'execution de l'action.

- `noRedirect`

  Booléen permetant de désactiver la redirection de l'utilisateur après l'execution de l'action.
  Cela permet à la fonction de définir son propre fichier de template de retour et donc d'afficher
  une page personnalisable.

- `rights`

  Tableau contenant la liste des noms des
  [LSprofiles](../global/ldap/LSprofile.md#profils-dutilisateurs) ayant le droit d'exécuter cette
  action.

## Écriture d'une fonction implémentant une customAction

Une fonction implémentant une *customAction* se déclare de la manière suivante :

```
/*
 * Ma fonction implémentant ma customAction
 *
 * Paramètre :
 *     - $object : Le LSobject sur lequel mon action doit être exécutée
 *
 * Valeurs retournées :
 *     - True : Tout s'est bien passé
 *     - False : Une erreur est survenue
 */
function maFonction ($object) {

  // Actions

}

```

Cette fonction doit prendre pour seul paramètre, le [LSobject](index.md#configuration-lsobject) sur
lequel l'action personnalisée doit être exécutée et doit retourner soit `True` si tout s'est bien
passé, soit `False` en cas de problème.

!!! note

    Ces fonctions sont le plus couramment définies au sein d'
    [LSaddon](../LSaddon/index.md#configuration-des-lsaddons).
