# Format paramétrable (LSfomat)

Un *format paramétrable* est une chaîne de caractères contenant des mots clés formés comme dans
l'exemple suivant :

```
%{[nom du mot clé][:A][:B][! ou _][~][%]}
```

Le nom du mot clé peut contenir des lettres de "a" à "z", de "A" à "Z" et des chiffres de 0 à 9. Ces
mots clés seront remplacés par les valeurs passées en paramètres et liées au contexte d'utilisation.
Les paramètres *:A* et *:B* permettent d'extraire une partie de la chaîne complète avant la
substitution.

Le paramètre `A` correspond, lorsque `B` n'est pas défini, au nombre maximum de caractères à
extraire de la chaîne de substitution. *A* doit être un entier dont le signe influ, comme expliqué
ci-dessous :

- Si `A` est positif, les `A` premiers caractères de la chaîne de substitution seront extraits.

- Si `A` est négatif, les `|A|` derniers caractères de la chaîne de substitution seront extraits.

Lorsque le paramètre `B` est défini, `A` correspond au rang du premier caractère à partir duquel la
chaîne de substitution sera découpée et `B` le nombre maximum de caractères à extraire. Le signe de
`B` influera comme expliqué dans le premier cas. Si `B` vaut zéro, la totalité de la longeur de la
chaîne sera retournée en tenant compte de `A` pour le rang du premier caractère.

Il existe par ailleurs des paramètres permettant de modifier la valeur de substitution avant son
utilisation :

- Les paramètres *!* ou *_* permettre respectivement de forcer la mise en majuscule ou en minuscule ;

- Le paramètre *~* permet de forcer la suppression des accents ;

- Le paramètre *%* permet de protéger les caractères éligibles en entités HTML.

!!! important

    Lorsque qu'une seule valeur clé est disponible pour la substitution, le nom du mot clé n'importe
    pas. Tous les mots clés trouvés dans le format seront remplacés par cette seule valeur.
