<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

/**
 * Type d'attribut HTML date
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 */
class LSattr_html_date extends LSattr_html {

  var $LSformElement_type = 'date';

  /**
   * Ajoute l'attribut au formualaire passer en paramètre
   *
   * @param LSform &$form  Le formulaire
   * @param string $idForm L'identifiant du formulaire
   * @param array|string|null $data Valeur du champs du formulaire
   *
   * @return LSformElement_date|false L'element du formulaire ajouté
   */
  function addToForm (&$form,$idForm,$data=NULL) {
    $element = parent::addToForm($form,$idForm,$data);
    $form -> addRule(
      $this -> name,
      'date',
      array(
        'msg' => _('Invalid value'),
        'params' => array(
          'format' => $element -> getFormat(),  // @phpstan-ignore-line
          'special_values' => array_keys($element -> getSpecialValues()),  // @phpstan-ignore-line
        )
      )
    );
    return (is_a($element, 'LSformElement_date')?$element:false);
  }

}
