<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

/**
 * Base d'une règle de validation d'une date
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 */
class LSformRule_date extends LSformRule {

  // CLI parameters autocompleters
  protected static array $cli_params_autocompleters = array(
    'format' => null,
    'special_values' => null,
  );

  /**
   * Validate form element value
   *
   * @param mixed $value The value to validate
   * @param array $options Validation options:
   *                         $options['params']['format']: the date format
   *                         $options['params']['special_values']: array of special allowed values
   * @param LSformElement &$formElement The related LSformElement object
   *
   * @return boolean True if value is valid, False otherwise
   */
  public static function validate($value, $options, &$formElement) {
    $special_values = LSconfig :: get('params.special_values', array(), null, $options);
    if (in_array($value, $special_values))
      return true;
    $format = LSconfig :: get('params.format', null, 'string', $options);
    if (is_null($format)) {
      LSerror :: addErrorCode('LSformRule_date_01');
      return false;
    }
    $date = strptime($value, $format);
    if(is_array($date)) {
      $res = mktime($date['tm_hour'],$date['tm_min'],$date['tm_sec'],$date['tm_mon']+1,$date['tm_mday'],$date['tm_year']+1900);
      if ((is_int($res)) && ($res != -1) && ($res !== False)) {
        return true;
      }
    }
    return false;
  }

}

/*
 * Error Codes
 */
LSerror :: defineError('LSformRule_date_01',
___("LSformRule_date : No date format specify.")
);
