<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

LSsession :: loadLSclass('LSlog_staticLoggerClass');

/**
 * Basic implementatin of a LDAP attribute type
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 */
class LSattr_ldap extends LSlog_staticLoggerClass {

  /**
   * LDAP attribute name
   * @var string
   */
  var string $name;

  /**
   * Attribute configuration (LSobjects.<type>.attrs.<attr_name>)
   * @var array<string,mixed>
   */
  var array $config;

  /**
   * The reference of the parent LSattribute object
   * @var LSattribute
   */
  var LSattribute $attribute;

  /**
   * Constructeur
   *
   * Cette methode construit l'objet et définis la configuration.
   *
   * @author Benjamin Renard <brenard@easter-eggs.com>
   *
   * @param string $name Nom de l'attribut ldap
   * @param array $config Configuration de l'objet
   * @param LSattribute &$attribute  L'objet LSattribut parent
   */
  public function __construct($name, $config, &$attribute) {
    $this -> name = $name;
    $this -> config = $config;
    $this -> attribute =& $attribute;
  }

  /**
   * Allow conversion of LSattr_ldap to string
   *
   * @return string The string representation of the LSattr_ldap
   */
  public function __toString() {
    return "<".get_class($this)." ".$this -> name.">";
  }

  /**
   * Return the update value of the attribute after handling it acording to its LDAP type
   *
   * @param mixed $data The attribute value
   *
   * @return mixed The processed attribute value
   */
  public function getUpdateData($data) {
    return ensureIsArray($data);
  }

  /**
   * Return the display value of the attribute after handling it acording to its LDAP type
   *
   * @param mixed $data The attribute value
   *
   * @return mixed The display value of the attribute
   */
  public function getDisplayValue($data) {
    return ensureIsArray($data);
  }

  /**
   * Retourne vrai si la valeur passé en paramètre n'était pas la même que la
   * valeur passer au formulaire
   *
   * @param mixed $data La valeur a tester
   *
   * @return boolean True uniquement si la valeur passer en paramètre différe de l'actuelle
   */
  public function isUpdated($data) {
    $data = $this -> getUpdateData($data);
    if ($this -> attribute -> data != $data) {
      return true;
    }
    return false;
  }

  /**
   * Return a configuration parameter (or default value)
   *
   * @param string $param      The configuration parameter
   * @param mixed $default    The default value (default : null)
   * @param string $cast       Cast resulting value in specific type (default : disabled)
   *
   * @return mixed The configuration parameter value or default value if not set
   **/
  public function getConfig($param, $default=null, $cast=null) {
    return LSconfig :: get($param, $default, $cast, $this -> config);
  }

}
