<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

/**
 * Check support of showSupportInfo addon by LdapSaisie
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 *
 * @return boolean true if LSaccessRightsMatrixView addon is totally supported, false in other case
 */
function LSaddon_showSupportInfo_support() {
  return LSsession :: registerLSaddonView(
    'showSupportInfo',
    'showMySupportInfo',
    _('Show my support information'),
    'showMySupportInfoView',
    array('user'),
    (defined('SHOW_SUPPORT_INFO_IN_MENU') && constant('SHOW_SUPPORT_INFO_IN_MENU'))
  );
}

function showMySupportInfo($object) {
  LSurl :: redirect('addon/showSupportInfo/showMySupportInfo');
}

function showMySupportInfoView() {
  $object = LSsession :: get('authenticated_user');
  LStemplate :: assign('public_url', LSurl :: get_public_absolute_url(""));
  LStemplate :: assign('object', $object);
  LStemplate :: assign('ldap_server_id', LSsession :: get('ldap_server_id'));
  LStemplate :: assign('root_dn', LSsession :: get('root_dn'));
  LStemplate :: assign('top_dn', LSsession :: get('top_dn'));
  LStemplate :: assign('sub_dn_name', LSsession :: get('sub_dn_name'));
  LStemplate :: assign('sub_dn_label', LSsession :: get('sub_dn_label'));
  LStemplate :: assign('LSprofiles', LSsession :: get('LSprofiles'));

  if (isset($_REQUEST['download'])) {
    header('Content-Type: text/plain');
    header('Content-disposition: attachment; filename="'.$object->rdn[0].'-support-info.txt"');
    print(LStemplate::fetch('showSupportInfo_raw.tpl'));
    exit();
  }

  LStemplate :: assign(
    'pagetitle',
    getFData(
      _('%{name}: Support information'),
      $object->getDisplayName()
    )
  );

  $LSview_actions = array();
  $LSview_actions['download'] = array (
    'label' => _('Download'),
    'url' => LSurl :: $request->current_url.'?download',
    'action' => 'vcard'
  );
  $LSview_actions['return'] = array (
    'label' => _('Go back'),
    'url' => 'object/SELF',
    'action' => 'view'
  );
  LStemplate :: assign('LSview_actions', $LSview_actions);

  if (LSsession :: loadLSclass('LSform')) {
    LSform :: loadDependenciesDisplayView();
  }

  LStemplate :: addCssFile('showSupportInfo.css');
  LSsession :: setTemplate('showSupportInfo.tpl');
  // Display template
  LSsession :: displayTemplate();
  exit();
}
